/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.HandleExistingSDK;
import com.quantumdata.quantumdatasdk.MainScreen;
import com.quantumdata.quantumdatasdk.QuantumDataSDK;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BackupExistingSDK
extends JFrame {
    private static final long serialVersionUID = 923430910569838862L;
    private static final String sCommandBrowse = "BROWSE";
    private static final String sCommandOk = "OK";
    private static final String sCommandNo = "NO";
    private static final String sCommandCancel = "CANCEL";
    File backUpLocation = null;
    private JTextField aBackUpLocation;

    public BackupExistingSDK(ActionListener actionListener) {
        this.InitScreen(actionListener);
    }

    protected void finalize() {
        this.backUpLocation = null;
    }

    private void InitScreen(ActionListener actionListener) {
        this.setTitle("Quantum Data SDK Setup");
        Container container = this.getContentPane();
        JLabel jLabel = MainScreen.getLabel("Back Up", 16, 1, true);
        JLabel jLabel2 = MainScreen.getLabel("Save existing SDK to:", 14, 0, true);
        this.aBackUpLocation = new JTextField(30);
        this.aBackUpLocation.setToolTipText("Enter the location you want to save the existing SDK");
        this.aBackUpLocation.setText(ConfigData.sSDKLocation);
        this.aBackUpLocation.addActionListener(actionListener);
        JButton jButton = new JButton("Browse...");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('B');
        jButton.setActionCommand(sCommandBrowse);
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Ok");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('O');
        jButton2.setActionCommand(sCommandOk);
        jButton2.addActionListener(actionListener);
        jButton2.setDefaultCapable(true);
        JButton jButton3 = new JButton("No, don't backup");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('N');
        jButton3.setActionCommand(sCommandNo);
        jButton3.addActionListener(actionListener);
        JButton jButton4 = new JButton("Cancel");
        jButton4.setVerticalTextPosition(0);
        jButton4.setHorizontalTextPosition(10);
        jButton4.setMnemonic('C');
        jButton4.setActionCommand(sCommandCancel);
        jButton4.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        int n = 0;
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 17);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 0, n, 0, 22);
        gridBagLayout.setConstraints(this.aBackUpLocation, gridBagConstraints);
        jPanel2.add(this.aBackUpLocation);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 1, n++, 0, 21);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel2.add(jButton);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        container.add((Component)jPanel2, "Center");
        container.validate();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public int ScreenHandler(ActionEvent actionEvent, int n) {
        int n2 = n;
        if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandBrowse)) {
            this.selectBackupLocation();
            if (this.backUpLocation != null) {
                this.aBackUpLocation.setText(this.backUpLocation.getAbsolutePath());
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandOk)) {
            if (this.backUpLocation == null && this.aBackUpLocation.getText().length() == 0) {
                JOptionPane.showMessageDialog(null, "Please specify a valid location first", "InvalidBackupLocation", 0);
            } else if (this.aBackUpLocation.getText().compareToIgnoreCase(ConfigData.sSDKLocation) == 0) {
                int n3 = JOptionPane.showConfirmDialog(this, "The backup location you specified is the same as current location!\nDo you want to specify any location?", "SameBackupLocation", 0);
                if (n3 == 1) {
                    n2 = 1;
                }
            } else if (this.backUpLocation != null && this.backUpSDK(this.backUpLocation.getAbsolutePath()) || this.aBackUpLocation.getText().length() != 0 && this.backUpSDK(this.aBackUpLocation.getText())) {
                n2 = 1;
            } else {
                QuantumDataSDK.ExitApp();
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandNo)) {
            JOptionPane.showMessageDialog(null, "Existing SDK will be overwriten if you choose to put the new SDK to the same location!", "OverwriteReminder", 1);
            n2 = 1;
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandCancel)) {
            QuantumDataSDK.ExitApp();
        }
        return n2;
    }

    private void selectBackupLocation() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select SDK Back Up Location");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setToolTipText("Enter SDK Back Up Location");
        jFileChooser.requestFocusInWindow();
        int n = jFileChooser.showDialog(this, "Select");
        if (n == 0) {
            this.backUpLocation = jFileChooser.getSelectedFile();
        }
    }

    private boolean backUpSDK(String string) {
        File file = new File(HandleExistingSDK.getSDKLocation());
        if (file.exists()) {
            File file2 = new File(string);
            boolean bl = file.renameTo(file2);
            if (bl) {
                JOptionPane.showMessageDialog(null, "The existing SDK has been successfully saved to: " + string + " !!", "BackupSuccessful", 1);
                System.out.println("File or directory rename is successfully.");
                return true;
            }
            System.out.println("File or directory does not rename successfully.");
            int n = JOptionPane.showConfirmDialog(this, "Copy existing SDK to: " + string + " failed!!\n" + "Do you want to continue with the installation?" + "Existing SDK will be overwriten if you choose to put the new SDK to the same location.", "Backup Failed", 0);
            return n == 0;
        }
        System.out.println("Directory " + HandleExistingSDK.getSDKLocation() + " does not exist.");
        return false;
    }
}

